	org 44597


; ==========================================================================
; ROUTINE 1: print the KABOOM and change the screen to white on black,
; correcting for where there are other colours or "things in the way"
; such as diagonally-divided squares

	; blank out PRINT AT line 21
	; then blank out the zaps with the same subroutine
	ld hl,whiteoutdata1	
	ld b,20
	call whiteout

	; EARTH-SHATTERING KABOOM!
	; Build the KABOOM up line by line
	ld hl,kaboomdata
	ld b,9		; 9 lines to be printed, and in each line:
	; first value (DEFW) is the DF address of the top line of the leftmost character		
	; next value is the number of characters to print
	; following values are: all top rows, all second rows, etc.
	call screenprint
	
	; now clear up a few extra dots
	ld hl,18259	; (2,19) 8th row
	ld (hl),1
	ld hl,17610	; (6,10) 5th row
	ld (hl),120
	ld hl,17621	; (6,21) 5th row
	ld (hl),126
	ld hl,20235	; (8,11) 8th row
	ld (hl),1

	; turn border to white and fill in the bottom two lines
	ld a,7
	out (254),a
	ld hl,23624	; BORDCR
	ld (hl),56
	; turn entire screen PAPER 7: INK 0: BRIGHT 1
	ld hl,22528
	ld (hl),120
	ld de,22529
	ld bc,767
	ldir
	; correct the borders to PAPER 0: INK 7: BRIGHT 1
	ld hl,22528
	ld a,71
	ld b,11
loop1a:	ld (hl),a
	inc hl
	djnz loop1a
	ld hl,22549
	ld b,12
loop1b:	ld (hl),a
	inc hl
	djnz loop1b
	ld hl,22591
	ld b,20
	ld de,31
loop1c:	ld (hl),a
	inc hl
	ld (hl),a
	add hl,de
	djnz loop1c
	ld hl,23201
	ld b,31
loop1d:	ld (hl),a
	inc hl
	djnz loop1d
	; ALL DONE!
	ret

; ==========================================================================
; ROUTINE 2: switch the black and white, then erase the KABOOM and reveal
; the crossed-out Evil Eye - starts at ORG+102

	; turn border to black and fill in the bottom two lines
	xor a	; LD A,0
	out (254),a
	ld hl,23624	; BORDCR
	ld (hl),7
	; swap all PAPER and INK attributes
	ld hl,22528
	ld bc,768
loop2a:	ld a,(hl)
	and 192	; take top two bits (FLASH and BRIGHT)
	ld e,a	; store in E
	ld a,(hl)
	and 56	; take bits 5,4,3 (PAPER) - carry cleared
	rra
	rra
	rra	; now where INK should be
	or e	; merge E into A
	ld e,a	; store FLASH, BRIGHT and new INK bits in E
	ld a,(hl)
	and 7	; take bits 2,1,0 (INK) - carry cleared
	rla
	rla
	rla	; now where PAPER should be
	or e	; merge E into A - A now contains the swapped PAPER and INK
	ld (hl),a
	inc hl
	dec bc
	ld a,b
	or c
	jr nz,loop2a

	; now deal with the un-KABOOMed eye - the WHITEOUT subroutine
	; (technically now a blackout) will remove some of the unwanted graphics
	ld hl,whiteoutdata2
	ld b,10	; this will change
	call whiteout

	; now revert three of those previous extra dots
	ld hl,17610	; (6,10) 5th row
	ld (hl),127
	ld hl,17621	; (6,21) 5th row
	ld (hl),254
	ld hl,20235	; (8,11) 8th row
	ld (hl),0

	; Reuild the eye with an X where the pupil was
	ld hl,xeyedata
	ld b,17		; 17 lines to be printed, and in each line:
	; first value (DEFW) is the DF address of the top line of the leftmost character		
	; next value is the number of characters to print
	; following values are: all top rows, all second rows, etc.
	call screenprint
	
	ret

; ==========================================================================
; Subroutines

whiteout:
	push bc
	ld e,(hl)	; lower byte of the DEFW is in E
	inc hl
	ld d,(hl)	; higher byte of the DEFW is in D
	inc hl
	ld a,(hl)	; DEFb byte (256 minus no. of times to loop)_is in A
	inc hl
	push hl		; HL is where we need it for the next loop so store it
	ex de,hl	; transfer DE to HL for the subroutine
	ld b,8	; NOTE: Number of squares to blank out = A
	ld d,0	; Number needed to send HL to next DF position = E
	ld e,a	; A + E = 256, hence store E in A first, then
	neg	; NEG (not CPL) converts A to the required value
subloop1a:
	push bc
	ld b,a
subloop1b:
	ld (hl),0
	inc hl
	djnz subloop1b
	add hl,de
	pop bc
	djnz subloop1a
	pop hl	; get HL back
	pop bc	; get BC back
	djnz whiteout
	ret

screenprint:	
	push bc
	ld e,(hl)	; low byte of the DEFW is put into E
	inc hl
	ld d,(hl)	; high byte of the DEFW is put into D
	inc hl
	ld c,(hl)	; next byte = number of characters in the line, put into C
	inc hl
	push de
	pop ix		; DE is copies to IX; DE is free to use again
	ld d,0
	xor a		; LD A,0 - or in this case, LD A,256
	sub c
	ld e,a		; DE is now 256-C, i.e. how much HL should be advanced by at the end of the subroutine
	; At this point: HL remains as the pointer for the data list
	; IX holds the screen address for the data to be dumped in
	ld b,8	; dealing with 8 rows to print
subloop1c:
	push bc	; store the outer loop variable
	ld b,c	; C already holds the number of times to loop here
subloop1d:
	ld a,(hl)
	ld (ix+0),a	; i.e. transfer (HL) to (IX)
	inc hl
	inc ix
	djnz subloop1d
	add ix,de	; adjusts IX to the next row of the leftmost character
	pop bc		; get the outer loop variable back
	djnz subloop1c
	pop bc		; get the loop variable back
	djnz screenprint
	ret

; ==========================================================================
; Data blocks

whiteoutdata1:
	defw 20642	; start at (21,2)
	defb 228	; blank out 28 squares
	defw 16395	; start at (0,11)
	defb 246	; blank out 10 squares
	defw 16424	; start at (1,8)
	defb 240	; blank out 16 squares
	defw 16456	; start at (2,8)
	defb 240	; blank out 16 squares
	defw 16489	; start at (3,9)
	defb 252	; blank out 4 squares
	defw 16499	; start at (3,19)
	defb 252	; blank out 4 squares
	defw 16517	; start at (4,5)
	defb 250	; blank out 6 squares
	defw 16533	; start at (4,21)
	defb 250	; blank out 6 squares
	defw 16551	; start at (5,7)
	defb 253	; blank out 3 squares
	defw 16566	; start at (5,22)
	defb 253	; blank out 3 squares
	defw 16615	; start at (7,7)
	defb 253	; blank out 3 squares
	defw 16630	; start at (7,22)
	defb 253	; blank out 3 squares
	defw 18437	; start at (8,5)
	defb 250	; blank out 6 squares
	defw 18453	; start at (8,21)
	defb 250	; blank out 6 squares
	defw 18473	; start at (9,9)
	defb 254	; blank out 2 squares
	defw 18485	; start at (9,21)
	defb 254	; blank out 2 squares
	defw 18504	; start at (10,8)
	defb 253	; blank out 3 squares
	defw 18517	; start at (10,21)
	defb 253	; blank out 3 squares
	defw 18536	; start at (11,8)
	defb 255	; blank out 1 square
	defw 18551	; start at (11,23)
	defb 255	; blank out 1 square

kaboomdata:
	defw 16431	; (1,15)
	defb 2		; 2 characters to print
	defb 0,0	; 1st row
	defb 0,0	; 2nd row
	defb 0,0	; 3rd row
	defb 1,0	; 4th row
	defb 1,0	; 5th row
	defb 1,0	; 6th row
	defb 1,128	; 7th row
	defb 2,128	; 8th row

	defw 16460	; (2,12)
	defb 5			; 2 characters to print
	defb 0,0,0,2,128	; 1st row
	defb 0,0,0,2,128	; 2nd row
	defb 0,0,0,2,64		; 3rd row
	defb 0,0,0,5,64		; 4th row
	defb 0,0,0,5,64		; 5th row
	defb 64,0,0,5,64	; 6th row
	defb 64,0,0,5,160	; 7th row
	defb 96,0,0,11,160	; 8th row

	defw 16492	; (3,12)
	defb 8		; 8 characters to print
	defb 48,0,0,11,160,0,0,3
	defb 44,0,0,11,208,0,0,6
	defb 34,0,0,11,208,0,0,26
	defb 21,0,0,215,215,0,0,36
	defb 22,128,31,215,215,248,0,212
	defb 23,65,255,215,235,255,129,40
	defb 23,167,255,215,235,255,230,232
	defb 11,219,255,175,235,255,217,208

	defw 16524	; (4,12)
	defb 8		; 8 characters to print
	defb 11,229,255,47,232,255,39,208
	defb 11,250,240,47,244,12,223,160
	defb 11,253,0,47,244,3,63,160
	defb 43,254,128,95,244,12,255,92
	defb 245,255,64,95,244,19,255,95
	defb 245,255,160,95,250,111,255,95
	defb 245,255,216,95,250,159,254,191
	defb 245,255,228,191,251,127,254,191

	defw 16556	; (5,12)
	defb 8		; 8 characters to print
	defb 250,255,250,191,250,255,253,127
	defb 250,255,253,191,249,255,253,31
	defb 242,255,254,191,251,255,250,15
	defb 226,255,255,63,255,255,250,7
	defb 193,127,255,191,255,255,243,3
	defb 129,127,255,255,255,255,253,1
	defb 1,127,255,255,255,255,254,192
	defb 3,127,255,255,255,255,255,48

	defw 16587	; (6,11)
	defb 10		; 10 characters to print
	defb 254,28,126,238,227,199,27,191,204,127
	defb 248,227,254,221,109,186,233,63,243,63
	defb 199,31,254,189,109,186,233,63,252,207
	defb 56,255,254,123,161,186,234,191,255,51
	defb 224,127,254,184,46,186,234,191,252,60
	defb 31,129,254,219,174,186,235,191,195,195
	defb 224,126,2,235,161,199,27,160,60,63
	defb 254,1,247,255,255,255,255,247,192,127

	defw 16620	; (7,12)
	defb 8		; 8 characters to print
	defb 0,47,255,255,255,255,250,0
	defb 0,95,255,255,255,255,253,0
	defb 128,191,255,255,255,255,253,1
	defb 196,191,255,255,255,223,254,131
	defb 225,127,255,127,255,207,254,135
	defb 226,255,252,127,127,211,255,79
	defb 229,255,243,127,127,220,255,175
	defb 229,255,205,126,191,211,63,175

	defw 18444	; (8,12)
	defb 8		; 8 characters to print
	defb 235,255,49,125,95,208,207,215
	defb 215,252,193,122,175,208,51,215
	defb 175,243,1,122,175,208,12,235
	defb 175,204,1,116,23,208,51,43
	defb 95,51,2,232,11,208,252,194
	defb 188,207,130,208,5,209,255,50
	defb 179,63,242,208,5,215,255,206
	defb 76,255,250,160,2,215,255,131

	defw 18475	; (9,11)
	defb 7		; 7 characters to print
	defb 2,48,63,250,95,253,107
	defb 4,192,15,250,191,254,171
	defb 7,0,1,251,191,255,75
	defb 12,0,0,27,127,255,168
	defb 0,0,0,6,255,255,40
	defb 0,0,0,4,0,0,24
	defb 0,0,0,4,0,0,8
	defb 0,0,0,0,0,0,8

whiteoutdata2:
	defw 16431	; start at (1,15)
	defb 254	; blank out 2 squares
	defw 16460	; start at (2,12)
	defb 248	; blank out 8 squares
	defw 16492	; start at (3,12)
	defb 255	; blank out 1 square
	defw 16499	; start at (3,19)
	defb 255	; blank out 1 square
	defw 16527	; start at (4,15)
	defb 254	; blank out 2 squares
	defw 16557	; start at (5,13)
	defb 250	; blank out 6 squares
	defw 16588	; start at (6,12)
	defb 248	; blank out 8 squares
	defw 16621	; start at (7,13)
	defb 250	; blank out 6 squares
	defw 18447	; start at (8,15)
	defb 254	; blank out 2 squares
	defw 18475	; start at (9,11)
	defb 254	; blank out 2 squares

xeyedata:
	defw 16493	; (3,13)
	defb 1		; 1 character to print
	defb 0
	defb 0
	defb 0
	defb 0
	defb 0
	defb 1
	defb 15
	defb 63
	
	defw 16495	; (3,15)
	defb 2		; 2 characters to print
	defb 0,0
	defb 0,0
	defb 0,0
	defb 255,255
	defb 255,255
	defb 255,255
	defb 255,255
	defb 255,255

	defw 16498	; (3,18)
	defb 1		; 1 character to print
	defb 0
	defb 0
	defb 0
	defb 0
	defb 0
	defb 128
	defb 240
	defb 252

	defw 16524	; (4,12)
	defb 3		; 3 characters to print
	defb 1,255,255
	defb 7,255,240
	defb 15,255,128
	defb 63,255,0
	defb 255,252,0
	defb 255,240,0
	defb 255,192,0
	defb 255,0,0

	defw 16529	; (4,17)
	defb 3		; 3 characters to print
	defb 255,255,128
	defb 15,255,224
	defb 1,255,240
	defb 0,255,252
	defb 0,63,255
	defb 0,15,255
	defb 0,3,255
	defb 0,0,255

	defw 16556	; (5,12)
	defb 1		; 1 character to print
	defb 254
	defb 248
	defb 240
	defb 224
	defb 192
	defb 128
	defb 0
	defb 0
	
	defw 16563	; (5,19)
	defb 1		; 1 character to print
	defb 127
	defb 31
	defb 15
	defb 7
	defb 3
	defb 1
	defb 0
	defb 0

	defw 16587	; (6,11)
	defb 1		; 1 character to print
	defb 254
	defb 252
	defb 248
	defb 240
	defb 240
	defb 248
	defb 252
	defb 254

	defw 16596	; (6,20)
	defb 1		; 1 character to print
	defb 127
	defb 63
	defb 31
	defb 15
	defb 15
	defb 31
	defb 63
	defb 127

	defw 16620	; (7,12)
	defb 1		; 1 character to print
	defb 0
	defb 0
	defb 128
	defb 192
	defb 224
	defb 240
	defb 248
	defb 254
	
	defw 16627	; (7,19)
	defb 1		; 1 character to print
	defb 0
	defb 0
	defb 1
	defb 3
	defb 7
	defb 15
	defb 31
	defb 127

	defw 18444	; (8,12)
	defb 3		; 3 characters to print
	defb 255,0,0
	defb 255,192,0
	defb 255,240,0
	defb 255,252,0
	defb 63,255,0
	defb 15,255,128
	defb 7,255,240
	defb 1,255,255

	defw 18449	; (8,17)
	defb 3		; 3 characters to print
	defb 0,0,255
	defb 0,3,255
	defb 0,15,255
	defb 0,63,255
	defb 0,255,252
	defb 1,255,240
	defb 15,255,224
	defb 255,255,128

	defw 18477	; (9,13)
	defb 6		; 6 characters to print
	defb 63,255,255,255,255,252
	defb 15,255,255,255,255,240
	defb 1,255,255,255,255,128
	defb 0,31,255,255,248,0
	defb 0,0,255,255,0,0
	defb 0,0,0,0,0,0
	defb 0,0,0,0,0,0
	defb 0,0,0,0,0,0

	defw 16558	; (5,14)
	defb 4		; 4 characters to print
	defb 8,0,0,16
	defb 4,0,0,32
	defb 2,0,0,64
	defb 1,0,0,128
	defb 0,192,3,0
	defb 0,224,7,0
	defb 0,112,14,0
	defb 0,60,60,0
	
	defw 16591	; (6,15)
	defb 2		; 2 characters to print
	defb 30,120
	defb 31,248
	defb 15,240
	defb 7,224
	defb 7,224
	defb 15,240
	defb 31,248
	defb 30,120

	defw 16622	; (7,14)
	defb 4		; 4 characters to print
	defb 0,60,60,0
	defb 0,112,14,0
	defb 0,224,7,0
	defb 0,192,3,0
	defb 1,0,0,128
	defb 2,0,0,64
	defb 4,0,0,32
	defb 8,0,0,16


